
{*******************************************************}
{                                                       }
{                Delphi XML-Datenbindung                }
{                                                       }
{         Erzeugt am: 26.09.02 11:17:32                 }
{       Erzeugt aus: C:\CDCollection.xml                }
{   Einstellungen gespeichert in: C:\CDCollection.xdb   }
{                                                       }
{*******************************************************}
unit CdCollectionUnit;

interface

uses xmldom, XMLDoc, XMLIntf;

type

{ Forward-Deklarationen }

  IXMLCDCollectionType = interface;
  IXMLCDType = interface;
  IXMLSingerType = interface;

{ IXMLCDCollectionType }

  IXMLCDCollectionType = interface(IXMLNodeCollection)
    ['{80439345-D141-11D6-B5F6-0080C79FF0E1}']
    { Zugriff auf Eigenschaften }
    function Get_CD(Index: Integer): IXMLCDType;
    { Methoden & Eigenschaften }
    function Add: IXMLCDType;
    function Insert(const Index: Integer): IXMLCDType;
    property CD[Index: Integer]: IXMLCDType read Get_CD; default;
  end;

{ IXMLCDType }

  IXMLCDType = interface(IXMLNode)
    ['{80439346-D141-11D6-B5F6-0080C79FF0E1}']
    { Zugriff auf Eigenschaften }
    function Get_Singer: IXMLSingerType;
    function Get_Title: WideString;
    function Get_Tracks: Integer;
    procedure Set_Title(Value: WideString);
    procedure Set_Tracks(Value: Integer);
    { Methoden & Eigenschaften }
    property Singer: IXMLSingerType read Get_Singer;
    property Title: WideString read Get_Title write Set_Title;
    property Tracks: Integer read Get_Tracks write Set_Tracks;
  end;

{ IXMLSingerType }

  IXMLSingerType = interface(IXMLNode)
    ['{80439347-D141-11D6-B5F6-0080C79FF0E1}']
    { Zugriff auf Eigenschaften }
    function Get_Gender: WideString;
    procedure Set_Gender(Value: WideString);
    { Methoden & Eigenschaften }
    property Gender: WideString read Get_Gender write Set_Gender;
  end;

{ Forward-Deklarationen }

  TXMLCDCollectionType = class;
  TXMLCDType = class;
  TXMLSingerType = class;

{ TXMLCDCollectionType }

  TXMLCDCollectionType = class(TXMLNodeCollection, IXMLCDCollectionType)
  protected
    { IXMLCDCollectionType }
    function Get_CD(Index: Integer): IXMLCDType;
    function Add: IXMLCDType;
    function Insert(const Index: Integer): IXMLCDType;
  public
    procedure AfterConstruction; override;
  end;

{ TXMLCDType }

  TXMLCDType = class(TXMLNode, IXMLCDType)
  protected
    { IXMLCDType }
    function Get_Singer: IXMLSingerType;
    function Get_Title: WideString;
    function Get_Tracks: Integer;
    procedure Set_Title(Value: WideString);
    procedure Set_Tracks(Value: Integer);
  public
    procedure AfterConstruction; override;
  end;

{ TXMLSingerType }

  TXMLSingerType = class(TXMLNode, IXMLSingerType)
  protected
    { IXMLSingerType }
    function Get_Gender: WideString;
    procedure Set_Gender(Value: WideString);
  end;

{ Globale Funktionen }

function GetCDCollection(Doc: IXMLDocument): IXMLCDCollectionType;
function LoadCDCollection(const FileName: WideString): IXMLCDCollectionType;
function NewCDCollection: IXMLCDCollectionType;

implementation

{ Globale Funktionen }

function GetCDCollection(Doc: IXMLDocument): IXMLCDCollectionType;
begin
  Result := Doc.GetDocBinding('CDCollection', TXMLCDCollectionType) as IXMLCDCollectionType;
end;
function LoadCDCollection(const FileName: WideString): IXMLCDCollectionType;
begin
  Result := LoadXMLDocument(FileName).GetDocBinding('CDCollection', TXMLCDCollectionType) as IXMLCDCollectionType;
end;

function NewCDCollection: IXMLCDCollectionType;
begin
  Result := NewXMLDocument.GetDocBinding('CDCollection', TXMLCDCollectionType) as IXMLCDCollectionType;
end;

{ TXMLCDCollectionType }

procedure TXMLCDCollectionType.AfterConstruction;
begin
  RegisterChildNode('CD', TXMLCDType);
  ItemTag := 'CD';
  ItemInterface := IXMLCDType;
  inherited;
end;

function TXMLCDCollectionType.Get_CD(Index: Integer): IXMLCDType;
begin
  Result := List[Index] as IXMLCDType;
end;

function TXMLCDCollectionType.Add: IXMLCDType;
begin
  Result := AddItem(-1) as IXMLCDType;
end;

function TXMLCDCollectionType.Insert(const Index: Integer): IXMLCDType;
begin
  Result := AddItem(Index) as IXMLCDType;
end;


{ TXMLCDType }

procedure TXMLCDType.AfterConstruction;
begin
  RegisterChildNode('singer', TXMLSingerType);
  inherited;
end;

function TXMLCDType.Get_Singer: IXMLSingerType;
begin
  Result := ChildNodes['singer'] as IXMLSingerType;
end;

function TXMLCDType.Get_Title: WideString;
begin
  Result := ChildNodes['title'].Text;
end;

procedure TXMLCDType.Set_Title(Value: WideString);
begin
  ChildNodes['title'].NodeValue := Value;
end;

function TXMLCDType.Get_Tracks: Integer;
begin
  Result := ChildNodes['tracks'].NodeValue;
end;

procedure TXMLCDType.Set_Tracks(Value: Integer);
begin
  ChildNodes['tracks'].NodeValue := Value;
end;

{ TXMLSingerType }

function TXMLSingerType.Get_Gender: WideString;
begin
  Result := AttributeNodes['gender'].Text;
end;

procedure TXMLSingerType.Set_Gender(Value: WideString);
begin
  SetAttribute('gender', Value);
end;

end.
